@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A favorite process identifier.
 * @property actualProcessName The actual name of the favorite process. It will be equal to resource name except for the scenario that the process name contains characters that are not allowed in the resource name.
 * @property id Resource ID.
 * @property name Resource name.
 * @property systemData The system metadata relating to this resource
 * @property type Resource type.
 */
public data class GetFavoriteProcessResult(
    public val actualProcessName: String,
    public val id: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetFavoriteProcessResult): GetFavoriteProcessResult = GetFavoriteProcessResult(
            actualProcessName = javaType.actualProcessName(),
            id = javaType.id(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
