@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The test base image definition resource.
 * @property architecture Custom image architecture.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property osState Custom image OS state.
 * @property provisioningState
 * @property securityType Custom image security type.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetImageDefinitionResult(
    public val architecture: String,
    public val id: String,
    public val name: String,
    public val osState: String,
    public val provisioningState: String,
    public val securityType: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetImageDefinitionResult): GetImageDefinitionResult = GetImageDefinitionResult(
            architecture = javaType.architecture(),
            id = javaType.id(),
            name = javaType.name(),
            osState = javaType.osState(),
            provisioningState = javaType.provisioningState(),
            securityType = javaType.securityType(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
