@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Test Base Package resource.
 * @property applicationName Application name
 * @property blobPath The file path of the package.
 * @property etag Resource Etag.
 * @property flightingRing The flighting ring for feature update.
 * @property id Resource ID.
 * @property isEnabled Flag showing that whether the package is enabled. It doesn't schedule test for package which is not enabled.
 * @property lastModifiedTime The UTC timestamp when the package was last modified.
 * @property location The geo-location where the resource lives
 * @property name Resource name.
 * @property packageStatus The status of the package.
 * @property provisioningState The provisioning state of the resource.
 * @property systemData The system metadata relating to this resource
 * @property tags The tags of the resource.
 * @property targetOSList Specifies the target OSs of specific OS Update types.
 * @property testTypes OOB, functional or both. Mapped to the data in 'tests' property.
 * @property tests The detailed test information.
 * @property type Resource type.
 * @property validationResults The validation results. There's validation on package when it's created or updated.
 * @property version Application version
 */
public data class GetPackageResult(
    public val applicationName: String,
    public val blobPath: String,
    public val etag: String,
    public val flightingRing: String,
    public val id: String,
    public val isEnabled: Boolean,
    public val lastModifiedTime: String,
    public val location: String,
    public val name: String,
    public val packageStatus: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val targetOSList: List<TargetOSInfoResponse>,
    public val testTypes: List<String>,
    public val tests: List<TestResponse>,
    public val type: String,
    public val validationResults: List<PackageValidationResultResponse>,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetPackageResult): GetPackageResult = GetPackageResult(
            applicationName = javaType.applicationName(),
            blobPath = javaType.blobPath(),
            etag = javaType.etag(),
            flightingRing = javaType.flightingRing(),
            id = javaType.id(),
            isEnabled = javaType.isEnabled(),
            lastModifiedTime = javaType.lastModifiedTime(),
            location = javaType.location(),
            name = javaType.name(),
            packageStatus = javaType.packageStatus(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetOSList = javaType.targetOSList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.TargetOSInfoResponse.Companion.toKotlin(args0)
                })
            }),
            testTypes = javaType.testTypes().map({ args0 -> args0 }),
            tests = javaType.tests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.TestResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            validationResults = javaType.validationResults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.PackageValidationResultResponse.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version(),
        )
    }
}
