@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The URL response
 * @property blobPath The blob path of the uploaded package. It will be used as the 'blobPath' property of PackageResource.
 * @property uploadUrl The URL used for uploading the package.
 */
public data class GetTestBaseAccountFileUploadUrlResult(
    public val blobPath: String,
    public val uploadUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetTestBaseAccountFileUploadUrlResult): GetTestBaseAccountFileUploadUrlResult = GetTestBaseAccountFileUploadUrlResult(
            blobPath = javaType.blobPath(),
            uploadUrl = javaType.uploadUrl(),
        )
    }
}
