@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The Test Base Account resource.
 * @property accessLevel The access level of the Test Base Account.
 * @property etag Resource Etag.
 * @property id Resource ID.
 * @property location The geo-location where the resource lives
 * @property name Resource name.
 * @property provisioningState The provisioning state of the resource.
 * @property sku The SKU of the Test Base Account.
 * @property systemData The system metadata relating to this resource
 * @property tags The tags of the resource.
 * @property type Resource type.
 */
public data class GetTestBaseAccountResult(
    public val accessLevel: String,
    public val etag: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sku: TestBaseAccountSKUResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetTestBaseAccountResult): GetTestBaseAccountResult = GetTestBaseAccountResult(
            accessLevel = javaType.accessLevel(),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.TestBaseAccountSKUResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
