@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The response of getting a download URL.
 * @property downloadUrl The download URL.
 * @property expirationTime Expiry date of the download URL.
 */
public data class GetTestResultDownloadURLResult(
    public val downloadUrl: String,
    public val expirationTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetTestResultDownloadURLResult): GetTestResultDownloadURLResult = GetTestResultDownloadURLResult(
            downloadUrl = javaType.downloadUrl(),
            expirationTime = javaType.expirationTime(),
        )
    }
}
