@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the baseline os and target os for in-place upgrade tests.
 * @property baselineOS Specifies the baseline os for in-place upgrade tests.
 * @property targetOS Specifies the target os for in-place upgrade tests.
 */
public data class InplaceUpgradeOSInfoResponse(
    public val baselineOS: OsPropertiesResponse? = null,
    public val targetOS: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.InplaceUpgradeOSInfoResponse): InplaceUpgradeOSInfoResponse = InplaceUpgradeOSInfoResponse(
            baselineOS = javaType.baselineOS().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.OsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetOS = javaType.targetOS().map({ args0 -> args0 }).orElse(null),
        )
    }
}
