@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A notification event receivers.
 * @property receiverType The type of the notification event receiver.
 * @property receiverValue The notification event receiver value.
 */
public data class NotificationEventReceiverResponse(
    public val receiverType: String? = null,
    public val receiverValue: NotificationReceiverValueResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.NotificationEventReceiverResponse): NotificationEventReceiverResponse = NotificationEventReceiverResponse(
            receiverType = javaType.receiverType().map({ args0 -> args0 }).orElse(null),
            receiverValue = javaType.receiverValue().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.NotificationReceiverValueResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
