@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Suppress

/**
 * A notification event receiver value.
 * @property distributionGroupListReceiverValue The user object receiver value.
 * @property subscriptionReceiverValue The user object receiver value.
 * @property userObjectReceiverValue The user object receiver value.
 */
public data class NotificationReceiverValueResponse(
    public val distributionGroupListReceiverValue: DistributionGroupListReceiverValueResponse? = null,
    public val subscriptionReceiverValue: SubscriptionReceiverValueResponse? = null,
    public val userObjectReceiverValue: UserObjectReceiverValueResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.NotificationReceiverValueResponse): NotificationReceiverValueResponse = NotificationReceiverValueResponse(
            distributionGroupListReceiverValue = javaType.distributionGroupListReceiverValue().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.DistributionGroupListReceiverValueResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subscriptionReceiverValue = javaType.subscriptionReceiverValue().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.SubscriptionReceiverValueResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userObjectReceiverValue = javaType.userObjectReceiverValue().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.UserObjectReceiverValueResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
