@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of an operating system.
 * @property customImageDisplayName The name of the custom image resource.
 * @property customImageId Specify the referenced Test Base Custom Image Id if available.
 * @property osName The name of the OS.
 * @property releaseProperties The properties of the OS release.
 */
public data class OsPropertiesResponse(
    public val customImageDisplayName: String,
    public val customImageId: String? = null,
    public val osName: String? = null,
    public val releaseProperties: ReleasePropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.OsPropertiesResponse): OsPropertiesResponse = OsPropertiesResponse(
            customImageDisplayName = javaType.customImageDisplayName(),
            customImageId = javaType.customImageId().map({ args0 -> args0 }).orElse(null),
            osName = javaType.osName().map({ args0 -> args0 }).orElse(null),
            releaseProperties = javaType.releaseProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.ReleasePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
