@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies current state of tabs.
 * @property currentTab Current tab.
 * @property visitedTabs visited tabs.
 */
public data class TabStateResponse(
    public val currentTab: String? = null,
    public val visitedTabs: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.TabStateResponse): TabStateResponse = TabStateResponse(
            currentTab = javaType.currentTab().map({ args0 -> args0 }).orElse(null),
            visitedTabs = javaType.visitedTabs().map({ args0 -> args0 }),
        )
    }
}
