@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the Test Base Account SKU Capability.
 * @property name An invariant to describe the feature, such as 'SLA'.
 * @property value An invariant if the feature is measured by quantity, such as 99.9%.
 */
public data class TestBaseAccountSKUCapabilityResponse(
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.TestBaseAccountSKUCapabilityResponse): TestBaseAccountSKUCapabilityResponse = TestBaseAccountSKUCapabilityResponse(
            name = javaType.name(),
            `value` = javaType.`value`(),
        )
    }
}
