@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a Test Base Account SKU.
 * @property capabilities The capabilities of a SKU.
 * @property locations The locations that the SKU is available.
 * @property name The name of the SKU. This is typically a letter + number code, such as B0 or S0.
 * @property resourceType The type of resource the SKU applies to.
 * @property tier The tier of this particular SKU.
 */
public data class TestBaseAccountSKUResponse(
    public val capabilities: List<TestBaseAccountSKUCapabilityResponse>,
    public val locations: List<String>? = null,
    public val name: String,
    public val resourceType: String? = null,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.TestBaseAccountSKUResponse): TestBaseAccountSKUResponse = TestBaseAccountSKUResponse(
            capabilities = javaType.capabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.TestBaseAccountSKUCapabilityResponse.Companion.toKotlin(args0)
                })
            }),
            locations = javaType.locations().map({ args0 -> args0 }),
            name = javaType.name(),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier(),
        )
    }
}
