@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The definition of a Test.
 * @property commands The commands used in the test.
 * @property isActive Indicates if this test is active.It doesn't schedule test for not active Test.
 * @property testType The type of the test.
 * @property validationResultId Resource identifier of the validation test result.
 * @property validationRunStatus The status of the validation run of the package.
 */
public data class TestResponse(
    public val commands: List<CommandResponse>,
    public val isActive: Boolean? = null,
    public val testType: String,
    public val validationResultId: String,
    public val validationRunStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.TestResponse): TestResponse = TestResponse(
            commands = javaType.commands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.CommandResponse.Companion.toKotlin(args0)
                })
            }),
            isActive = javaType.isActive().map({ args0 -> args0 }).orElse(null),
            testType = javaType.testType(),
            validationResultId = javaType.validationResultId(),
            validationRunStatus = javaType.validationRunStatus(),
        )
    }
}
