@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.LocalTimestampResponse
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.LocalTimestampResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EventHubEventSource].
 */
@PulumiTagMarker
public class EventHubEventSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventHubEventSourceArgs = EventHubEventSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventHubEventSourceArgsBuilder.() -> Unit) {
        val builder = EventHubEventSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventHubEventSource {
        val builtJavaResource =
            com.pulumi.azurenative.timeseriesinsights.EventHubEventSource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EventHubEventSource(builtJavaResource)
    }
}

/**
 * An event source that receives its data from an Azure EventHub.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * ## Example Usage
 * ### CreateEventHubEventSource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubEventSource = new AzureNative.TimeSeriesInsights.EventHubEventSource("eventHubEventSource", new()
 *     {
 *         ConsumerGroupName = "cgn",
 *         EnvironmentName = "env1",
 *         EventHubName = "ehn",
 *         EventSourceName = "es1",
 *         EventSourceResourceId = "somePathInArm",
 *         KeyName = "managementKey",
 *         Kind = "Microsoft.EventHub",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         ServiceBusNamespace = "sbn",
 *         SharedAccessKey = "someSecretvalue",
 *         TimestampPropertyName = "someTimestampProperty",
 *         Type = AzureNative.TimeSeriesInsights.IngressStartAtType.EarliestAvailable,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewEventHubEventSource(ctx, "eventHubEventSource", &timeseriesinsights.EventHubEventSourceArgs{
 * 			ConsumerGroupName:     pulumi.String("cgn"),
 * 			EnvironmentName:       pulumi.String("env1"),
 * 			EventHubName:          pulumi.String("ehn"),
 * 			EventSourceName:       pulumi.String("es1"),
 * 			EventSourceResourceId: pulumi.String("somePathInArm"),
 * 			KeyName:               pulumi.String("managementKey"),
 * 			Kind:                  pulumi.String("Microsoft.EventHub"),
 * 			Location:              pulumi.String("West US"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			ServiceBusNamespace:   pulumi.String("sbn"),
 * 			SharedAccessKey:       pulumi.String("someSecretvalue"),
 * 			TimestampPropertyName: pulumi.String("someTimestampProperty"),
 * 			Type:                  pulumi.String(timeseriesinsights.IngressStartAtTypeEarliestAvailable),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.EventHubEventSource;
 * import com.pulumi.azurenative.timeseriesinsights.EventHubEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubEventSource = new EventHubEventSource("eventHubEventSource", EventHubEventSourceArgs.builder()
 *             .consumerGroupName("cgn")
 *             .environmentName("env1")
 *             .eventHubName("ehn")
 *             .eventSourceName("es1")
 *             .eventSourceResourceId("somePathInArm")
 *             .keyName("managementKey")
 *             .kind("Microsoft.EventHub")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .serviceBusNamespace("sbn")
 *             .sharedAccessKey("someSecretvalue")
 *             .timestampPropertyName("someTimestampProperty")
 *             .type("EarliestAvailable")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSourcesCreateEventHubWithCustomEnquedTime
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubEventSource = new AzureNative.TimeSeriesInsights.EventHubEventSource("eventHubEventSource", new()
 *     {
 *         ConsumerGroupName = "cgn",
 *         EnvironmentName = "env1",
 *         EventHubName = "ehn",
 *         EventSourceName = "es1",
 *         EventSourceResourceId = "somePathInArm",
 *         KeyName = "managementKey",
 *         Kind = "Microsoft.EventHub",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         ServiceBusNamespace = "sbn",
 *         SharedAccessKey = "someSecretvalue",
 *         Time = "2017-04-01T19:20:33.2288820Z",
 *         TimestampPropertyName = "someTimestampProperty",
 *         Type = AzureNative.TimeSeriesInsights.IngressStartAtType.CustomEnqueuedTime,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewEventHubEventSource(ctx, "eventHubEventSource", &timeseriesinsights.EventHubEventSourceArgs{
 * 			ConsumerGroupName:     pulumi.String("cgn"),
 * 			EnvironmentName:       pulumi.String("env1"),
 * 			EventHubName:          pulumi.String("ehn"),
 * 			EventSourceName:       pulumi.String("es1"),
 * 			EventSourceResourceId: pulumi.String("somePathInArm"),
 * 			KeyName:               pulumi.String("managementKey"),
 * 			Kind:                  pulumi.String("Microsoft.EventHub"),
 * 			Location:              pulumi.String("West US"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			ServiceBusNamespace:   pulumi.String("sbn"),
 * 			SharedAccessKey:       pulumi.String("someSecretvalue"),
 * 			Time:                  pulumi.String("2017-04-01T19:20:33.2288820Z"),
 * 			TimestampPropertyName: pulumi.String("someTimestampProperty"),
 * 			Type:                  pulumi.String(timeseriesinsights.IngressStartAtTypeCustomEnqueuedTime),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.EventHubEventSource;
 * import com.pulumi.azurenative.timeseriesinsights.EventHubEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubEventSource = new EventHubEventSource("eventHubEventSource", EventHubEventSourceArgs.builder()
 *             .consumerGroupName("cgn")
 *             .environmentName("env1")
 *             .eventHubName("ehn")
 *             .eventSourceName("es1")
 *             .eventSourceResourceId("somePathInArm")
 *             .keyName("managementKey")
 *             .kind("Microsoft.EventHub")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .serviceBusNamespace("sbn")
 *             .sharedAccessKey("someSecretvalue")
 *             .time("2017-04-01T19:20:33.2288820Z")
 *             .timestampPropertyName("someTimestampProperty")
 *             .type("CustomEnqueuedTime")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:EventHubEventSource es1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/eventSources/{eventSourceName}
 * ```
 */
public class EventHubEventSource internal constructor(
    override val javaResource: com.pulumi.azurenative.timeseriesinsights.EventHubEventSource,
) : KotlinCustomResource(javaResource, EventHubEventSourceMapper) {
    /**
     * The name of the event hub's consumer group that holds the partitions from which events will be read.
     */
    public val consumerGroupName: Output<String>
        get() = javaResource.consumerGroupName().applyValue({ args0 -> args0 })

    /**
     * The time the resource was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The name of the event hub.
     */
    public val eventHubName: Output<String>
        get() = javaResource.eventHubName().applyValue({ args0 -> args0 })

    /**
     * The resource id of the event source in Azure Resource Manager.
     */
    public val eventSourceResourceId: Output<String>
        get() = javaResource.eventSourceResourceId().applyValue({ args0 -> args0 })

    /**
     * The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access policies for this key must grant 'Listen' permissions to the event hub.
     */
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    /**
     * The kind of the event source.
     * Expected value is 'Microsoft.EventHub'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
     */
    public val localTimestamp: Output<LocalTimestampResponse>?
        get() = javaResource.localTimestamp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The name of the service bus that contains the event hub.
     */
    public val serviceBusNamespace: Output<String>
        get() = javaResource.serviceBusNamespace().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the starting point for Events to be consumed.
     */
    public val time: Output<String>?
        get() = javaResource.time().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
     */
    public val timestampPropertyName: Output<String>?
        get() = javaResource.timestampPropertyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EventHubEventSourceMapper : ResourceMapper<EventHubEventSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.timeseriesinsights.EventHubEventSource::class == javaResource::class

    override fun map(javaResource: Resource): EventHubEventSource = EventHubEventSource(
        javaResource
            as com.pulumi.azurenative.timeseriesinsights.EventHubEventSource,
    )
}

/**
 * @see [EventHubEventSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventHubEventSource].
 */
public suspend fun eventHubEventSource(
    name: String,
    block: suspend EventHubEventSourceResourceBuilder.() -> Unit,
): EventHubEventSource {
    val builder = EventHubEventSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventHubEventSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventHubEventSource(name: String): EventHubEventSource {
    val builder = EventHubEventSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
