@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.Gen2EnvironmentArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.Gen2StorageConfigurationInputArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.Gen2StorageConfigurationInputArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.TimeSeriesIdPropertyArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.TimeSeriesIdPropertyArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.WarmStoreConfigurationPropertiesArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.WarmStoreConfigurationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen2 environments do not have set data retention limits.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * ## Example Usage
 * ### EnvironmentsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gen2Environment = new AzureNative.TimeSeriesInsights.Gen2Environment("gen2Environment", new()
 *     {
 *         EnvironmentName = "env1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewGen2Environment(ctx, "gen2Environment", &timeseriesinsights.Gen2EnvironmentArgs{
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.Gen2Environment;
 * import com.pulumi.azurenative.timeseriesinsights.Gen2EnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gen2Environment = new Gen2Environment("gen2Environment", Gen2EnvironmentArgs.builder()
 *             .environmentName("env1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:Gen2Environment env1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}
 * ```
 * @property environmentName Name of the environment
 * @property kind The kind of the environment.
 * Expected value is 'Gen2'.
 * @property location The location of the resource.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property sku The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
 * @property storageConfiguration The storage configuration provides the connection details that allows the Time Series Insights service to connect to the customer storage account that is used to store the environment's data.
 * @property tags Key-value pairs of additional properties for the resource.
 * @property timeSeriesIdProperties The list of event properties which will be used to define the environment's time series id.
 * @property warmStoreConfiguration The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's data available for faster query.
 */
public data class Gen2EnvironmentArgs(
    public val environmentName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val storageConfiguration: Output<Gen2StorageConfigurationInputArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeSeriesIdProperties: Output<List<TimeSeriesIdPropertyArgs>>? = null,
    public val warmStoreConfiguration: Output<WarmStoreConfigurationPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.Gen2EnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.Gen2EnvironmentArgs =
        com.pulumi.azurenative.timeseriesinsights.Gen2EnvironmentArgs.builder()
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageConfiguration(
                storageConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeSeriesIdProperties(
                timeSeriesIdProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .warmStoreConfiguration(
                warmStoreConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [Gen2EnvironmentArgs].
 */
@PulumiTagMarker
public class Gen2EnvironmentArgsBuilder internal constructor() {
    private var environmentName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var storageConfiguration: Output<Gen2StorageConfigurationInputArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeSeriesIdProperties: Output<List<TimeSeriesIdPropertyArgs>>? = null

    private var warmStoreConfiguration: Output<WarmStoreConfigurationPropertiesArgs>? = null

    /**
     * @param value Name of the environment
     */
    @JvmName("vaxcbrmviluswxfo")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The kind of the environment.
     * Expected value is 'Gen2'.
     */
    @JvmName("tuwitbyyivqoynnq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("wowpstylnstfduhy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("jhhixphewsvvndlr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
     */
    @JvmName("efvyurdolfledlku")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The storage configuration provides the connection details that allows the Time Series Insights service to connect to the customer storage account that is used to store the environment's data.
     */
    @JvmName("oqtosrgvusaubccc")
    public suspend fun storageConfiguration(`value`: Output<Gen2StorageConfigurationInputArgs>) {
        this.storageConfiguration = value
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("ojoqmrqogeywxsvv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The list of event properties which will be used to define the environment's time series id.
     */
    @JvmName("swjdpmogthkhmhut")
    public suspend fun timeSeriesIdProperties(`value`: Output<List<TimeSeriesIdPropertyArgs>>) {
        this.timeSeriesIdProperties = value
    }

    @JvmName("ajwgnouepmsleliw")
    public suspend fun timeSeriesIdProperties(vararg values: Output<TimeSeriesIdPropertyArgs>) {
        this.timeSeriesIdProperties = Output.all(values.asList())
    }

    /**
     * @param values The list of event properties which will be used to define the environment's time series id.
     */
    @JvmName("xixkmfgnppoldsaa")
    public suspend fun timeSeriesIdProperties(values: List<Output<TimeSeriesIdPropertyArgs>>) {
        this.timeSeriesIdProperties = Output.all(values)
    }

    /**
     * @param value The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's data available for faster query.
     */
    @JvmName("cidhusvcsineaixn")
    public suspend fun warmStoreConfiguration(`value`: Output<WarmStoreConfigurationPropertiesArgs>) {
        this.warmStoreConfiguration = value
    }

    /**
     * @param value Name of the environment
     */
    @JvmName("crrxbjfvmbomgfxf")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The kind of the environment.
     * Expected value is 'Gen2'.
     */
    @JvmName("uqsroqruyffhlkuf")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("luvmtmmyrpkmikqv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("bcvmdhhjeewnecqq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
     */
    @JvmName("bkvywoojalssfujt")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
     */
    @JvmName("bulvlnbiugisuwpi")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The storage configuration provides the connection details that allows the Time Series Insights service to connect to the customer storage account that is used to store the environment's data.
     */
    @JvmName("uwbpmritntqpbvac")
    public suspend fun storageConfiguration(`value`: Gen2StorageConfigurationInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageConfiguration = mapped
    }

    /**
     * @param argument The storage configuration provides the connection details that allows the Time Series Insights service to connect to the customer storage account that is used to store the environment's data.
     */
    @JvmName("unykuhsmuhvctbwt")
    public suspend fun storageConfiguration(argument: suspend Gen2StorageConfigurationInputArgsBuilder.() -> Unit) {
        val toBeMapped = Gen2StorageConfigurationInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageConfiguration = mapped
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("ealabpasftsdskvj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional properties for the resource.
     */
    @JvmName("fxytxbtncpmbcsuw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The list of event properties which will be used to define the environment's time series id.
     */
    @JvmName("sukykrlrufsuslaf")
    public suspend fun timeSeriesIdProperties(`value`: List<TimeSeriesIdPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeriesIdProperties = mapped
    }

    /**
     * @param argument The list of event properties which will be used to define the environment's time series id.
     */
    @JvmName("eabbltddthacgqcp")
    public suspend fun timeSeriesIdProperties(argument: List<suspend TimeSeriesIdPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TimeSeriesIdPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timeSeriesIdProperties = mapped
    }

    /**
     * @param argument The list of event properties which will be used to define the environment's time series id.
     */
    @JvmName("xftvwkdyksdktcth")
    public suspend fun timeSeriesIdProperties(vararg argument: suspend TimeSeriesIdPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TimeSeriesIdPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timeSeriesIdProperties = mapped
    }

    /**
     * @param argument The list of event properties which will be used to define the environment's time series id.
     */
    @JvmName("acueuknuivruricn")
    public suspend fun timeSeriesIdProperties(argument: suspend TimeSeriesIdPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TimeSeriesIdPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.timeSeriesIdProperties = mapped
    }

    /**
     * @param values The list of event properties which will be used to define the environment's time series id.
     */
    @JvmName("krojufuncjbxmkew")
    public suspend fun timeSeriesIdProperties(vararg values: TimeSeriesIdPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeSeriesIdProperties = mapped
    }

    /**
     * @param value The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's data available for faster query.
     */
    @JvmName("lafbpewmemtgtiww")
    public suspend fun warmStoreConfiguration(`value`: WarmStoreConfigurationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmStoreConfiguration = mapped
    }

    /**
     * @param argument The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's data available for faster query.
     */
    @JvmName("lomwpuitlvtfmmps")
    public suspend fun warmStoreConfiguration(argument: suspend WarmStoreConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WarmStoreConfigurationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.warmStoreConfiguration = mapped
    }

    internal fun build(): Gen2EnvironmentArgs = Gen2EnvironmentArgs(
        environmentName = environmentName,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        storageConfiguration = storageConfiguration,
        tags = tags,
        timeSeriesIdProperties = timeSeriesIdProperties,
        warmStoreConfiguration = warmStoreConfiguration,
    )
}
