@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.LocalTimestampResponse
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.LocalTimestampResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IoTHubEventSource].
 */
@PulumiTagMarker
public class IoTHubEventSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IoTHubEventSourceArgs = IoTHubEventSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IoTHubEventSourceArgsBuilder.() -> Unit) {
        val builder = IoTHubEventSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IoTHubEventSource {
        val builtJavaResource =
            com.pulumi.azurenative.timeseriesinsights.IoTHubEventSource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IoTHubEventSource(builtJavaResource)
    }
}

/**
 * An event source that receives its data from an Azure IoTHub.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * ## Example Usage
 * ### CreateEventHubEventSource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ioTHubEventSource = new AzureNative.TimeSeriesInsights.IoTHubEventSource("ioTHubEventSource", new()
 *     {
 *         EnvironmentName = "env1",
 *         EventSourceName = "es1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewIoTHubEventSource(ctx, "ioTHubEventSource", &timeseriesinsights.IoTHubEventSourceArgs{
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			EventSourceName:   pulumi.String("es1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.IoTHubEventSource;
 * import com.pulumi.azurenative.timeseriesinsights.IoTHubEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ioTHubEventSource = new IoTHubEventSource("ioTHubEventSource", IoTHubEventSourceArgs.builder()
 *             .environmentName("env1")
 *             .eventSourceName("es1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSourcesCreateEventHubWithCustomEnquedTime
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ioTHubEventSource = new AzureNative.TimeSeriesInsights.IoTHubEventSource("ioTHubEventSource", new()
 *     {
 *         EnvironmentName = "env1",
 *         EventSourceName = "es1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewIoTHubEventSource(ctx, "ioTHubEventSource", &timeseriesinsights.IoTHubEventSourceArgs{
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			EventSourceName:   pulumi.String("es1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.IoTHubEventSource;
 * import com.pulumi.azurenative.timeseriesinsights.IoTHubEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ioTHubEventSource = new IoTHubEventSource("ioTHubEventSource", IoTHubEventSourceArgs.builder()
 *             .environmentName("env1")
 *             .eventSourceName("es1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:IoTHubEventSource es1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/eventSources/{eventSourceName}
 * ```
 */
public class IoTHubEventSource internal constructor(
    override val javaResource: com.pulumi.azurenative.timeseriesinsights.IoTHubEventSource,
) : KotlinCustomResource(javaResource, IoTHubEventSourceMapper) {
    /**
     * The name of the iot hub's consumer group that holds the partitions from which events will be read.
     */
    public val consumerGroupName: Output<String>
        get() = javaResource.consumerGroupName().applyValue({ args0 -> args0 })

    /**
     * The time the resource was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The resource id of the event source in Azure Resource Manager.
     */
    public val eventSourceResourceId: Output<String>
        get() = javaResource.eventSourceResourceId().applyValue({ args0 -> args0 })

    /**
     * The name of the iot hub.
     */
    public val iotHubName: Output<String>
        get() = javaResource.iotHubName().applyValue({ args0 -> args0 })

    /**
     * The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub. This shared access policy key must grant 'service connect' permissions to the iot hub.
     */
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    /**
     * The kind of the event source.
     * Expected value is 'Microsoft.IoTHub'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
     */
    public val localTimestamp: Output<LocalTimestampResponse>?
        get() = javaResource.localTimestamp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the starting point for Events to be consumed.
     */
    public val time: Output<String>?
        get() = javaResource.time().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
     */
    public val timestampPropertyName: Output<String>?
        get() = javaResource.timestampPropertyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IoTHubEventSourceMapper : ResourceMapper<IoTHubEventSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.timeseriesinsights.IoTHubEventSource::class == javaResource::class

    override fun map(javaResource: Resource): IoTHubEventSource = IoTHubEventSource(
        javaResource as
            com.pulumi.azurenative.timeseriesinsights.IoTHubEventSource,
    )
}

/**
 * @see [IoTHubEventSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IoTHubEventSource].
 */
public suspend fun ioTHubEventSource(
    name: String,
    block: suspend IoTHubEventSourceResourceBuilder.() -> Unit,
): IoTHubEventSource {
    val builder = IoTHubEventSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IoTHubEventSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ioTHubEventSource(name: String): IoTHubEventSource {
    val builder = IoTHubEventSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
