@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.IoTHubEventSourceArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.enums.IngressStartAtType
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.LocalTimestampArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.LocalTimestampArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An event source that receives its data from an Azure IoTHub.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * ## Example Usage
 * ### CreateEventHubEventSource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ioTHubEventSource = new AzureNative.TimeSeriesInsights.IoTHubEventSource("ioTHubEventSource", new()
 *     {
 *         EnvironmentName = "env1",
 *         EventSourceName = "es1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewIoTHubEventSource(ctx, "ioTHubEventSource", &timeseriesinsights.IoTHubEventSourceArgs{
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			EventSourceName:   pulumi.String("es1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.IoTHubEventSource;
 * import com.pulumi.azurenative.timeseriesinsights.IoTHubEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ioTHubEventSource = new IoTHubEventSource("ioTHubEventSource", IoTHubEventSourceArgs.builder()
 *             .environmentName("env1")
 *             .eventSourceName("es1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSourcesCreateEventHubWithCustomEnquedTime
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ioTHubEventSource = new AzureNative.TimeSeriesInsights.IoTHubEventSource("ioTHubEventSource", new()
 *     {
 *         EnvironmentName = "env1",
 *         EventSourceName = "es1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewIoTHubEventSource(ctx, "ioTHubEventSource", &timeseriesinsights.IoTHubEventSourceArgs{
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			EventSourceName:   pulumi.String("es1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.IoTHubEventSource;
 * import com.pulumi.azurenative.timeseriesinsights.IoTHubEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ioTHubEventSource = new IoTHubEventSource("ioTHubEventSource", IoTHubEventSourceArgs.builder()
 *             .environmentName("env1")
 *             .eventSourceName("es1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:IoTHubEventSource es1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/eventSources/{eventSourceName}
 * ```
 * @property consumerGroupName The name of the iot hub's consumer group that holds the partitions from which events will be read.
 * @property environmentName The name of the Time Series Insights environment associated with the specified resource group.
 * @property eventSourceName Name of the event source.
 * @property eventSourceResourceId The resource id of the event source in Azure Resource Manager.
 * @property iotHubName The name of the iot hub.
 * @property keyName The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub. This shared access policy key must grant 'service connect' permissions to the iot hub.
 * @property kind The kind of the event source.
 * Expected value is 'Microsoft.IoTHub'.
 * @property localTimestamp An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
 * @property location The location of the resource.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property sharedAccessKey The value of the Shared Access Policy key that grants the Time Series Insights service read access to the iot hub. This property is not shown in event source responses.
 * @property tags Key-value pairs of additional properties for the resource.
 * @property time ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the starting point for Events to be consumed.
 * @property timestampPropertyName The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
 * @property type The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
 */
public data class IoTHubEventSourceArgs(
    public val consumerGroupName: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val eventSourceName: Output<String>? = null,
    public val eventSourceResourceId: Output<String>? = null,
    public val iotHubName: Output<String>? = null,
    public val keyName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val localTimestamp: Output<LocalTimestampArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sharedAccessKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val time: Output<String>? = null,
    public val timestampPropertyName: Output<String>? = null,
    public val type: Output<Either<String, IngressStartAtType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.IoTHubEventSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.IoTHubEventSourceArgs =
        com.pulumi.azurenative.timeseriesinsights.IoTHubEventSourceArgs.builder()
            .consumerGroupName(consumerGroupName?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .eventSourceName(eventSourceName?.applyValue({ args0 -> args0 }))
            .eventSourceResourceId(eventSourceResourceId?.applyValue({ args0 -> args0 }))
            .iotHubName(iotHubName?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .localTimestamp(localTimestamp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sharedAccessKey(sharedAccessKey?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .time(time?.applyValue({ args0 -> args0 }))
            .timestampPropertyName(timestampPropertyName?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IoTHubEventSourceArgs].
 */
@PulumiTagMarker
public class IoTHubEventSourceArgsBuilder internal constructor() {
    private var consumerGroupName: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var eventSourceName: Output<String>? = null

    private var eventSourceResourceId: Output<String>? = null

    private var iotHubName: Output<String>? = null

    private var keyName: Output<String>? = null

    private var kind: Output<String>? = null

    private var localTimestamp: Output<LocalTimestampArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sharedAccessKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var time: Output<String>? = null

    private var timestampPropertyName: Output<String>? = null

    private var type: Output<Either<String, IngressStartAtType>>? = null

    /**
     * @param value The name of the iot hub's consumer group that holds the partitions from which events will be read.
     */
    @JvmName("evcrmvjklacbjkpc")
    public suspend fun consumerGroupName(`value`: Output<String>) {
        this.consumerGroupName = value
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("kkkfyjgobqbsmhjn")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Name of the event source.
     */
    @JvmName("srqvwbklwqtpejop")
    public suspend fun eventSourceName(`value`: Output<String>) {
        this.eventSourceName = value
    }

    /**
     * @param value The resource id of the event source in Azure Resource Manager.
     */
    @JvmName("yvtakgxtosdluqmb")
    public suspend fun eventSourceResourceId(`value`: Output<String>) {
        this.eventSourceResourceId = value
    }

    /**
     * @param value The name of the iot hub.
     */
    @JvmName("imsrddatkrhhwwfn")
    public suspend fun iotHubName(`value`: Output<String>) {
        this.iotHubName = value
    }

    /**
     * @param value The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub. This shared access policy key must grant 'service connect' permissions to the iot hub.
     */
    @JvmName("eyfixtcokchkwntd")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The kind of the event source.
     * Expected value is 'Microsoft.IoTHub'.
     */
    @JvmName("proekohybtpknwdh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
     */
    @JvmName("dkknsgjxpynrcwyd")
    public suspend fun localTimestamp(`value`: Output<LocalTimestampArgs>) {
        this.localTimestamp = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("ugbpidbepfhmhhmi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("vmvumuiiyfrxpfmm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The value of the Shared Access Policy key that grants the Time Series Insights service read access to the iot hub. This property is not shown in event source responses.
     */
    @JvmName("rwxilmpsemtxftug")
    public suspend fun sharedAccessKey(`value`: Output<String>) {
        this.sharedAccessKey = value
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("yxustwkomeilkpsi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the starting point for Events to be consumed.
     */
    @JvmName("ivyqicclittgdnyl")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
     */
    @JvmName("unanhtmbdplryqhn")
    public suspend fun timestampPropertyName(`value`: Output<String>) {
        this.timestampPropertyName = value
    }

    /**
     * @param value The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
     */
    @JvmName("gmfvqoaxawqasqiv")
    public suspend fun type(`value`: Output<Either<String, IngressStartAtType>>) {
        this.type = value
    }

    /**
     * @param value The name of the iot hub's consumer group that holds the partitions from which events will be read.
     */
    @JvmName("qtekghmhkyadwnpn")
    public suspend fun consumerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupName = mapped
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("kqmwhopxfigxjemq")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the event source.
     */
    @JvmName("nvhxcdxqaotxgfex")
    public suspend fun eventSourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSourceName = mapped
    }

    /**
     * @param value The resource id of the event source in Azure Resource Manager.
     */
    @JvmName("mgfetblpelwrlvvs")
    public suspend fun eventSourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSourceResourceId = mapped
    }

    /**
     * @param value The name of the iot hub.
     */
    @JvmName("ougydslnraqrvtwy")
    public suspend fun iotHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotHubName = mapped
    }

    /**
     * @param value The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub. This shared access policy key must grant 'service connect' permissions to the iot hub.
     */
    @JvmName("whihhyjxwmsnxojg")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The kind of the event source.
     * Expected value is 'Microsoft.IoTHub'.
     */
    @JvmName("pnqsdlkshpxknjfx")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
     */
    @JvmName("okojihtjwmkybvgp")
    public suspend fun localTimestamp(`value`: LocalTimestampArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localTimestamp = mapped
    }

    /**
     * @param argument An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
     */
    @JvmName("txuvuvstufenysak")
    public suspend fun localTimestamp(argument: suspend LocalTimestampArgsBuilder.() -> Unit) {
        val toBeMapped = LocalTimestampArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localTimestamp = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("rnhgiqaaigrfbcwl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("ojpucyswatuitydi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The value of the Shared Access Policy key that grants the Time Series Insights service read access to the iot hub. This property is not shown in event source responses.
     */
    @JvmName("ctkfsgkgsyooxxud")
    public suspend fun sharedAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessKey = mapped
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("bakdlgmyfrbansuu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional properties for the resource.
     */
    @JvmName("oqqxsmnbcitbtgay")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the starting point for Events to be consumed.
     */
    @JvmName("yliqujpxafqyileh")
    public suspend fun time(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.time = mapped
    }

    /**
     * @param value The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
     */
    @JvmName("fuwvdqfjvkqgcaxf")
    public suspend fun timestampPropertyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampPropertyName = mapped
    }

    /**
     * @param value The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
     */
    @JvmName("bxbjqmsaienabixy")
    public suspend fun type(`value`: Either<String, IngressStartAtType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
     */
    @JvmName("lfcjwusvshgqhsry")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IngressStartAtType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
     */
    @JvmName("eqbdcdjthakkvmak")
    public fun type(`value`: IngressStartAtType) {
        val toBeMapped = Either.ofRight<String, IngressStartAtType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IoTHubEventSourceArgs = IoTHubEventSourceArgs(
        consumerGroupName = consumerGroupName,
        environmentName = environmentName,
        eventSourceName = eventSourceName,
        eventSourceResourceId = eventSourceResourceId,
        iotHubName = iotHubName,
        keyName = keyName,
        kind = kind,
        localTimestamp = localTimestamp,
        location = location,
        resourceGroupName = resourceGroupName,
        sharedAccessKey = sharedAccessKey,
        tags = tags,
        time = time,
        timestampPropertyName = timestampPropertyName,
        type = type,
    )
}
