@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.ReferenceDataSetArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.enums.DataStringComparisonBehavior
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.ReferenceDataSetKeyPropertyArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.ReferenceDataSetKeyPropertyArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified through the Time Series Insights data plane APIs.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * Other available API versions: 2017-11-15, 2021-06-30-preview.
 * ## Example Usage
 * ### ReferenceDataSetsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var referenceDataSet = new AzureNative.TimeSeriesInsights.ReferenceDataSet("referenceDataSet", new()
 *     {
 *         EnvironmentName = "env1",
 *         KeyProperties = new[]
 *         {
 *             new AzureNative.TimeSeriesInsights.Inputs.ReferenceDataSetKeyPropertyArgs
 *             {
 *                 Name = "DeviceId1",
 *                 Type = AzureNative.TimeSeriesInsights.ReferenceDataKeyPropertyType.String,
 *             },
 *             new AzureNative.TimeSeriesInsights.Inputs.ReferenceDataSetKeyPropertyArgs
 *             {
 *                 Name = "DeviceFloor",
 *                 Type = AzureNative.TimeSeriesInsights.ReferenceDataKeyPropertyType.Double,
 *             },
 *         },
 *         Location = "West US",
 *         ReferenceDataSetName = "rds1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewReferenceDataSet(ctx, "referenceDataSet", &timeseriesinsights.ReferenceDataSetArgs{
 * 			EnvironmentName: pulumi.String("env1"),
 * 			KeyProperties: timeseriesinsights.ReferenceDataSetKeyPropertyArray{
 * 				&timeseriesinsights.ReferenceDataSetKeyPropertyArgs{
 * 					Name: pulumi.String("DeviceId1"),
 * 					Type: pulumi.String(timeseriesinsights.ReferenceDataKeyPropertyTypeString),
 * 				},
 * 				&timeseriesinsights.ReferenceDataSetKeyPropertyArgs{
 * 					Name: pulumi.String("DeviceFloor"),
 * 					Type: pulumi.String(timeseriesinsights.ReferenceDataKeyPropertyTypeDouble),
 * 				},
 * 			},
 * 			Location:             pulumi.String("West US"),
 * 			ReferenceDataSetName: pulumi.String("rds1"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.ReferenceDataSet;
 * import com.pulumi.azurenative.timeseriesinsights.ReferenceDataSetArgs;
 * import com.pulumi.azurenative.timeseriesinsights.inputs.ReferenceDataSetKeyPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var referenceDataSet = new ReferenceDataSet("referenceDataSet", ReferenceDataSetArgs.builder()
 *             .environmentName("env1")
 *             .keyProperties(
 *                 ReferenceDataSetKeyPropertyArgs.builder()
 *                     .name("DeviceId1")
 *                     .type("String")
 *                     .build(),
 *                 ReferenceDataSetKeyPropertyArgs.builder()
 *                     .name("DeviceFloor")
 *                     .type("Double")
 *                     .build())
 *             .location("West US")
 *             .referenceDataSetName("rds1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:ReferenceDataSet rds1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/referenceDataSets/{referenceDataSetName}
 * ```
 * @property dataStringComparisonBehavior The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which means case sensitive key comparison will be performed while joining reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
 * @property environmentName The name of the Time Series Insights environment associated with the specified resource group.
 * @property keyProperties The list of key properties for the reference data set.
 * @property location The location of the resource.
 * @property referenceDataSetName Name of the reference data set.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property tags Key-value pairs of additional properties for the resource.
 */
public data class ReferenceDataSetArgs(
    public val dataStringComparisonBehavior: Output<Either<String, DataStringComparisonBehavior>>? =
        null,
    public val environmentName: Output<String>? = null,
    public val keyProperties: Output<List<ReferenceDataSetKeyPropertyArgs>>? = null,
    public val location: Output<String>? = null,
    public val referenceDataSetName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.ReferenceDataSetArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.ReferenceDataSetArgs =
        com.pulumi.azurenative.timeseriesinsights.ReferenceDataSetArgs.builder()
            .dataStringComparisonBehavior(
                dataStringComparisonBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .keyProperties(
                keyProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .referenceDataSetName(referenceDataSetName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReferenceDataSetArgs].
 */
@PulumiTagMarker
public class ReferenceDataSetArgsBuilder internal constructor() {
    private var dataStringComparisonBehavior: Output<Either<String, DataStringComparisonBehavior>>? =
        null

    private var environmentName: Output<String>? = null

    private var keyProperties: Output<List<ReferenceDataSetKeyPropertyArgs>>? = null

    private var location: Output<String>? = null

    private var referenceDataSetName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which means case sensitive key comparison will be performed while joining reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
     */
    @JvmName("mtidqiggumccoprl")
    public suspend fun dataStringComparisonBehavior(`value`: Output<Either<String, DataStringComparisonBehavior>>) {
        this.dataStringComparisonBehavior = value
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("trxqfreoypuxewts")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The list of key properties for the reference data set.
     */
    @JvmName("hxlmcfrsujfinfmd")
    public suspend fun keyProperties(`value`: Output<List<ReferenceDataSetKeyPropertyArgs>>) {
        this.keyProperties = value
    }

    @JvmName("vdwnydmambisodsb")
    public suspend fun keyProperties(vararg values: Output<ReferenceDataSetKeyPropertyArgs>) {
        this.keyProperties = Output.all(values.asList())
    }

    /**
     * @param values The list of key properties for the reference data set.
     */
    @JvmName("bbbxslnskqpikaah")
    public suspend fun keyProperties(values: List<Output<ReferenceDataSetKeyPropertyArgs>>) {
        this.keyProperties = Output.all(values)
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("hegohtyltjivwxar")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the reference data set.
     */
    @JvmName("qniuexoygfvrnbdv")
    public suspend fun referenceDataSetName(`value`: Output<String>) {
        this.referenceDataSetName = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("qnfpabiikernrbvf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("wiyswlndyewrbyet")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which means case sensitive key comparison will be performed while joining reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
     */
    @JvmName("wmjqagtwtceqrewi")
    public suspend fun dataStringComparisonBehavior(`value`: Either<String, DataStringComparisonBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataStringComparisonBehavior = mapped
    }

    /**
     * @param value The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which means case sensitive key comparison will be performed while joining reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
     */
    @JvmName("dbwktmghdxqbvbdq")
    public fun dataStringComparisonBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataStringComparisonBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStringComparisonBehavior = mapped
    }

    /**
     * @param value The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which means case sensitive key comparison will be performed while joining reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
     */
    @JvmName("xhhcaohlsatlimso")
    public fun dataStringComparisonBehavior(`value`: DataStringComparisonBehavior) {
        val toBeMapped = Either.ofRight<String, DataStringComparisonBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStringComparisonBehavior = mapped
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("xqpwwlqnpclodjwc")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The list of key properties for the reference data set.
     */
    @JvmName("sxtidkuwnojwgdkx")
    public suspend fun keyProperties(`value`: List<ReferenceDataSetKeyPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyProperties = mapped
    }

    /**
     * @param argument The list of key properties for the reference data set.
     */
    @JvmName("pljakogfcfexvesx")
    public suspend fun keyProperties(argument: List<suspend ReferenceDataSetKeyPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReferenceDataSetKeyPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyProperties = mapped
    }

    /**
     * @param argument The list of key properties for the reference data set.
     */
    @JvmName("jpmoxxlgxjowfykq")
    public suspend fun keyProperties(vararg argument: suspend ReferenceDataSetKeyPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReferenceDataSetKeyPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyProperties = mapped
    }

    /**
     * @param argument The list of key properties for the reference data set.
     */
    @JvmName("jnilersycjbsptsm")
    public suspend fun keyProperties(argument: suspend ReferenceDataSetKeyPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReferenceDataSetKeyPropertyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.keyProperties = mapped
    }

    /**
     * @param values The list of key properties for the reference data set.
     */
    @JvmName("bnccyufmcpjfwkrh")
    public suspend fun keyProperties(vararg values: ReferenceDataSetKeyPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyProperties = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("pkungufpkgcaggio")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the reference data set.
     */
    @JvmName("cibyqxgnpjqnquff")
    public suspend fun referenceDataSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceDataSetName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("gxbefydltscixksp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("pyuksecvqtwwigmc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional properties for the resource.
     */
    @JvmName("epxyytghjflcihei")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReferenceDataSetArgs = ReferenceDataSetArgs(
        dataStringComparisonBehavior = dataStringComparisonBehavior,
        environmentName = environmentName,
        keyProperties = keyProperties,
        location = location,
        referenceDataSetName = referenceDataSetName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
