@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.GetAccessPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessPolicyName The name of the Time Series Insights access policy associated with the specified environment.
 * @property environmentName The name of the Time Series Insights environment associated with the specified resource group.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetAccessPolicyPlainArgs(
    public val accessPolicyName: String,
    public val environmentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.GetAccessPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.inputs.GetAccessPolicyPlainArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.GetAccessPolicyPlainArgs.builder()
            .accessPolicyName(accessPolicyName.let({ args0 -> args0 }))
            .environmentName(environmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetAccessPolicyPlainArgsBuilder internal constructor() {
    private var accessPolicyName: String? = null

    private var environmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Time Series Insights access policy associated with the specified environment.
     */
    @JvmName("stnlluknhyvaitwe")
    public suspend fun accessPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessPolicyName = mapped
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("ghhndppdrjclqati")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("auwdytvyqgyygspe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccessPolicyPlainArgs = GetAccessPolicyPlainArgs(
        accessPolicyName = accessPolicyName ?: throw PulumiNullFieldException("accessPolicyName"),
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
