@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.GetEventHubEventSourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName The name of the Time Series Insights environment associated with the specified resource group.
 * @property eventSourceName The name of the Time Series Insights event source associated with the specified environment.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetEventHubEventSourcePlainArgs(
    public val environmentName: String,
    public val eventSourceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.GetEventHubEventSourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.inputs.GetEventHubEventSourcePlainArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.GetEventHubEventSourcePlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .eventSourceName(eventSourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventHubEventSourcePlainArgs].
 */
@PulumiTagMarker
public class GetEventHubEventSourcePlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var eventSourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("uloxaskfolypulbf")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the Time Series Insights event source associated with the specified environment.
     */
    @JvmName("okewoaitfolxhbni")
    public suspend fun eventSourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSourceName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("qrcybsakwknnaqoe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEventHubEventSourcePlainArgs = GetEventHubEventSourcePlainArgs(
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        eventSourceName = eventSourceName ?: throw PulumiNullFieldException("eventSourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
