@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.ReferenceDataSetKeyPropertyArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.enums.ReferenceDataKeyPropertyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A key property for the reference data set. A reference data set can have multiple key properties.
 * @property name The name of the key property.
 * @property type The type of the key property.
 */
public data class ReferenceDataSetKeyPropertyArgs(
    public val name: Output<String>? = null,
    public val type: Output<Either<String, ReferenceDataKeyPropertyType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.ReferenceDataSetKeyPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.inputs.ReferenceDataSetKeyPropertyArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.ReferenceDataSetKeyPropertyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReferenceDataSetKeyPropertyArgs].
 */
@PulumiTagMarker
public class ReferenceDataSetKeyPropertyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, ReferenceDataKeyPropertyType>>? = null

    /**
     * @param value The name of the key property.
     */
    @JvmName("wklvdyrwrwuynocg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the key property.
     */
    @JvmName("nrlmsggaxyrppqwr")
    public suspend fun type(`value`: Output<Either<String, ReferenceDataKeyPropertyType>>) {
        this.type = value
    }

    /**
     * @param value The name of the key property.
     */
    @JvmName("hywxytrrscfifmsq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of the key property.
     */
    @JvmName("lplmmcqnpdwtvdvu")
    public suspend fun type(`value`: Either<String, ReferenceDataKeyPropertyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the key property.
     */
    @JvmName("bjaqecmynpvcsfhr")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReferenceDataKeyPropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the key property.
     */
    @JvmName("gngbnekpcphsfxwo")
    public fun type(`value`: ReferenceDataKeyPropertyType) {
        val toBeMapped = Either.ofRight<String, ReferenceDataKeyPropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReferenceDataSetKeyPropertyArgs = ReferenceDataSetKeyPropertyArgs(
        name = name,
        type = type,
    )
}
