@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that contains the details about an environment's state.
 * @property code Contains the code that represents the reason of an environment being in a particular state. Can be used to programmatically handle specific cases.
 * @property message A message that describes the state in detail.
 */
public data class EnvironmentStateDetailsResponse(
    public val code: String? = null,
    public val message: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.EnvironmentStateDetailsResponse): EnvironmentStateDetailsResponse = EnvironmentStateDetailsResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
