@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An event source that receives its data from an Azure EventHub.
 * @property consumerGroupName The name of the event hub's consumer group that holds the partitions from which events will be read.
 * @property creationTime The time the resource was created.
 * @property eventHubName The name of the event hub.
 * @property eventSourceResourceId The resource id of the event source in Azure Resource Manager.
 * @property id Resource Id
 * @property keyName The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access policies for this key must grant 'Listen' permissions to the event hub.
 * @property kind The kind of the event source.
 * Expected value is 'Microsoft.EventHub'.
 * @property localTimestamp An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState Provisioning state of the resource.
 * @property serviceBusNamespace The name of the service bus that contains the event hub.
 * @property tags Resource tags
 * @property time ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the starting point for Events to be consumed.
 * @property timestampPropertyName The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
 * @property type Resource type
 */
public data class GetEventHubEventSourceResult(
    public val consumerGroupName: String,
    public val creationTime: String,
    public val eventHubName: String,
    public val eventSourceResourceId: String,
    public val id: String,
    public val keyName: String,
    public val kind: String,
    public val localTimestamp: LocalTimestampResponse? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val serviceBusNamespace: String,
    public val tags: Map<String, String>? = null,
    public val time: String? = null,
    public val timestampPropertyName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.GetEventHubEventSourceResult): GetEventHubEventSourceResult = GetEventHubEventSourceResult(
            consumerGroupName = javaType.consumerGroupName(),
            creationTime = javaType.creationTime(),
            eventHubName = javaType.eventHubName(),
            eventSourceResourceId = javaType.eventSourceResourceId(),
            id = javaType.id(),
            keyName = javaType.keyName(),
            kind = javaType.kind(),
            localTimestamp = javaType.localTimestamp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.LocalTimestampResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            serviceBusNamespace = javaType.serviceBusNamespace(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            time = javaType.time().map({ args0 -> args0 }).orElse(null),
            timestampPropertyName = javaType.timestampPropertyName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
