@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen1 environments have data retention limits.
 * @property creationTime The time the resource was created.
 * @property dataAccessFqdn The fully qualified domain name used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
 * @property dataAccessId An id used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
 * @property dataRetentionTime ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
 * @property id Resource Id
 * @property kind The kind of the environment.
 * Expected value is 'Gen1'.
 * @property location Resource location
 * @property name Resource name
 * @property partitionKeyProperties The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
 * @property provisioningState Provisioning state of the resource.
 * @property sku The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
 * @property status An object that represents the status of the environment, and its internal state in the Time Series Insights service.
 * @property storageLimitExceededBehavior The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetGen1EnvironmentResult(
    public val creationTime: String,
    public val dataAccessFqdn: String,
    public val dataAccessId: String,
    public val dataRetentionTime: String,
    public val id: String,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val partitionKeyProperties: List<TimeSeriesIdPropertyResponse>? = null,
    public val provisioningState: String,
    public val sku: SkuResponse,
    public val status: EnvironmentStatusResponse,
    public val storageLimitExceededBehavior: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.GetGen1EnvironmentResult): GetGen1EnvironmentResult = GetGen1EnvironmentResult(
            creationTime = javaType.creationTime(),
            dataAccessFqdn = javaType.dataAccessFqdn(),
            dataAccessId = javaType.dataAccessId(),
            dataRetentionTime = javaType.dataRetentionTime(),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            partitionKeyProperties = javaType.partitionKeyProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.TimeSeriesIdPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.EnvironmentStatusResponse.Companion.toKotlin(args0)
            }),
            storageLimitExceededBehavior = javaType.storageLimitExceededBehavior().map({ args0 ->
                args0
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
