@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified through the Time Series Insights data plane APIs.
 * @property creationTime The time the resource was created.
 * @property dataStringComparisonBehavior The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which means case sensitive key comparison will be performed while joining reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
 * @property id Resource Id
 * @property keyProperties The list of key properties for the reference data set.
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState Provisioning state of the resource.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetReferenceDataSetResult(
    public val creationTime: String,
    public val dataStringComparisonBehavior: String? = null,
    public val id: String,
    public val keyProperties: List<ReferenceDataSetKeyPropertyResponse>,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.GetReferenceDataSetResult): GetReferenceDataSetResult = GetReferenceDataSetResult(
            creationTime = javaType.creationTime(),
            dataStringComparisonBehavior = javaType.dataStringComparisonBehavior().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            keyProperties = javaType.keyProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.ReferenceDataSetKeyPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
