@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that represents the status of ingress on an environment.
 * @property state This string represents the state of ingress operations on an environment. It can be "Disabled", "Ready", "Running", "Paused" or "Unknown"
 * @property stateDetails An object that contains the details about an environment's state.
 */
public data class IngressEnvironmentStatusResponse(
    public val state: String? = null,
    public val stateDetails: EnvironmentStateDetailsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.IngressEnvironmentStatusResponse): IngressEnvironmentStatusResponse = IngressEnvironmentStatusResponse(
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            stateDetails = javaType.stateDetails().let({ args0 ->
                com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.EnvironmentStateDetailsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
