@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
 * @property format An enum that represents the format of the local timestamp property that needs to be set.
 * @property timeZoneOffset An object that represents the offset information for the local timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.
 */
public data class LocalTimestampResponse(
    public val format: String? = null,
    public val timeZoneOffset: LocalTimestampResponseTimeZoneOffset? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.LocalTimestampResponse): LocalTimestampResponse = LocalTimestampResponse(
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            timeZoneOffset = javaType.timeZoneOffset().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.LocalTimestampResponseTimeZoneOffset.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
