@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A key property for the reference data set. A reference data set can have multiple key properties.
 * @property name The name of the key property.
 * @property type The type of the key property.
 */
public data class ReferenceDataSetKeyPropertyResponse(
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.ReferenceDataSetKeyPropertyResponse): ReferenceDataSetKeyPropertyResponse = ReferenceDataSetKeyPropertyResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
