@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The structure of the property that a time series id can have. An environment can have multiple such properties.
 * @property name The name of the property.
 * @property type The type of the property.
 */
public data class TimeSeriesIdPropertyResponse(
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.TimeSeriesIdPropertyResponse): TimeSeriesIdPropertyResponse = TimeSeriesIdPropertyResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
