@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An object that represents the status of warm storage on an environment.
 * @property currentCount A value that represents the number of properties used by the environment for S1/S2 SKU and number of properties used by Warm Store for PAYG SKU
 * @property maxCount A value that represents the maximum number of properties used allowed by the environment for S1/S2 SKU and maximum number of properties allowed by Warm Store for PAYG SKU.
 * @property state This string represents the state of warm storage properties usage. It can be "Ok", "Error", "Unknown".
 */
public data class WarmStorageEnvironmentStatusResponse(
    public val currentCount: Int? = null,
    public val maxCount: Int? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.WarmStorageEnvironmentStatusResponse): WarmStorageEnvironmentStatusResponse = WarmStorageEnvironmentStatusResponse(
            currentCount = javaType.currentCount().map({ args0 -> args0 }).orElse(null),
            maxCount = javaType.maxCount().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
