@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's data available for faster query.
 * @property dataRetention ISO8601 timespan specifying the number of days the environment's events will be available for query from the warm store.
 */
public data class WarmStoreConfigurationPropertiesResponse(
    public val dataRetention: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.WarmStoreConfigurationPropertiesResponse): WarmStoreConfigurationPropertiesResponse = WarmStoreConfigurationPropertiesResponse(
            dataRetention = javaType.dataRetention(),
        )
    }
}
