@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.verifiedid.kotlin

import com.pulumi.azurenative.verifiedid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.verifiedid.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Authority].
 */
@PulumiTagMarker
public class AuthorityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorityArgs = AuthorityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorityArgsBuilder.() -> Unit) {
        val builder = AuthorityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Authority {
        val builtJavaResource = com.pulumi.azurenative.verifiedid.Authority(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Authority(builtJavaResource)
    }
}

/**
 * A VerifiedId authority resource
 * Azure REST API version: 2024-01-26-preview.
 * ## Example Usage
 * ### CreateAuthority
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authority = new AzureNative.VerifiedId.Authority("authority", new()
 *     {
 *         AuthorityName = "00000000-0000-0000-0000-000000000111",
 *         Location = "westus",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/verifiedid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedid.NewAuthority(ctx, "authority", &verifiedid.AuthorityArgs{
 * 			AuthorityName:     pulumi.String("00000000-0000-0000-0000-000000000111"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.verifiedid.Authority;
 * import com.pulumi.azurenative.verifiedid.AuthorityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authority = new Authority("authority", AuthorityArgs.builder()
 *             .authorityName("00000000-0000-0000-0000-000000000111")
 *             .location("westus")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:verifiedid:Authority myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VerifiedId/authorities/{authorityName}
 * ```
 */
public class Authority internal constructor(
    override val javaResource: com.pulumi.azurenative.verifiedid.Authority,
) : KotlinCustomResource(javaResource, AuthorityMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AuthorityMapper : ResourceMapper<Authority> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.verifiedid.Authority::class == javaResource::class

    override fun map(javaResource: Resource): Authority = Authority(
        javaResource as
            com.pulumi.azurenative.verifiedid.Authority,
    )
}

/**
 * @see [Authority].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Authority].
 */
public suspend fun authority(name: String, block: suspend AuthorityResourceBuilder.() -> Unit): Authority {
    val builder = AuthorityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Authority].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authority(name: String): Authority {
    val builder = AuthorityResourceBuilder()
    builder.name(name)
    return builder.build()
}
