@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.verifiedid.kotlin

import com.pulumi.azurenative.verifiedid.AuthorityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A VerifiedId authority resource
 * Azure REST API version: 2024-01-26-preview.
 * ## Example Usage
 * ### CreateAuthority
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authority = new AzureNative.VerifiedId.Authority("authority", new()
 *     {
 *         AuthorityName = "00000000-0000-0000-0000-000000000111",
 *         Location = "westus",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/verifiedid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedid.NewAuthority(ctx, "authority", &verifiedid.AuthorityArgs{
 * 			AuthorityName:     pulumi.String("00000000-0000-0000-0000-000000000111"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.verifiedid.Authority;
 * import com.pulumi.azurenative.verifiedid.AuthorityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authority = new Authority("authority", AuthorityArgs.builder()
 *             .authorityName("00000000-0000-0000-0000-000000000111")
 *             .location("westus")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:verifiedid:Authority myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VerifiedId/authorities/{authorityName}
 * ```
 * @property authorityName The ID of the authority
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AuthorityArgs(
    public val authorityName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.verifiedid.AuthorityArgs> {
    override fun toJava(): com.pulumi.azurenative.verifiedid.AuthorityArgs =
        com.pulumi.azurenative.verifiedid.AuthorityArgs.builder()
            .authorityName(authorityName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AuthorityArgs].
 */
@PulumiTagMarker
public class AuthorityArgsBuilder internal constructor() {
    private var authorityName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of the authority
     */
    @JvmName("yeoljipheempqkfy")
    public suspend fun authorityName(`value`: Output<String>) {
        this.authorityName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yukcuuprjjojuodo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wqrhhwyyufokxmfu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hjvpnxfbuwwvavsm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the authority
     */
    @JvmName("sdetbrcyladxhajc")
    public suspend fun authorityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorityName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ddaswevygrhkjlsr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("crtcqlajnufymqjr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bvmgeggcjbgaxsih")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("axgolwkdsggygcdg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AuthorityArgs = AuthorityArgs(
        authorityName = authorityName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
