@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.verifiedid.kotlin

import com.pulumi.azurenative.verifiedid.VerifiedidFunctions.getAuthorityPlain
import com.pulumi.azurenative.verifiedid.kotlin.inputs.GetAuthorityPlainArgs
import com.pulumi.azurenative.verifiedid.kotlin.inputs.GetAuthorityPlainArgsBuilder
import com.pulumi.azurenative.verifiedid.kotlin.outputs.GetAuthorityResult
import com.pulumi.azurenative.verifiedid.kotlin.outputs.GetAuthorityResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object VerifiedidFunctions {
    /**
     * Get a Authority
     * Azure REST API version: 2024-01-26-preview.
     * @param argument null
     * @return A VerifiedId authority resource
     */
    public suspend fun getAuthority(argument: GetAuthorityPlainArgs): GetAuthorityResult =
        toKotlin(getAuthorityPlain(argument.toJava()).await())

    /**
     * @see [getAuthority].
     * @param authorityName The ID of the authority
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A VerifiedId authority resource
     */
    public suspend fun getAuthority(authorityName: String, resourceGroupName: String): GetAuthorityResult {
        val argument = GetAuthorityPlainArgs(
            authorityName = authorityName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getAuthorityPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthority].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;verifiedid&#46;kotlin&#46;inputs&#46;GetAuthorityPlainArgs].
     * @return A VerifiedId authority resource
     */
    public suspend fun getAuthority(argument: suspend GetAuthorityPlainArgsBuilder.() -> Unit): GetAuthorityResult {
        val builder = GetAuthorityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAuthorityPlain(builtArgument.toJava()).await())
    }
}
