@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.verifiedid.kotlin.inputs

import com.pulumi.azurenative.verifiedid.inputs.GetAuthorityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorityName The ID of the authority
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAuthorityPlainArgs(
    public val authorityName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.verifiedid.inputs.GetAuthorityPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.verifiedid.inputs.GetAuthorityPlainArgs =
        com.pulumi.azurenative.verifiedid.inputs.GetAuthorityPlainArgs.builder()
            .authorityName(authorityName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthorityPlainArgs].
 */
@PulumiTagMarker
public class GetAuthorityPlainArgsBuilder internal constructor() {
    private var authorityName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The ID of the authority
     */
    @JvmName("njuwylvgbsvocwsm")
    public suspend fun authorityName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorityName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("olffjbaopkcutwnr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAuthorityPlainArgs = GetAuthorityPlainArgs(
        authorityName = authorityName ?: throw PulumiNullFieldException("authorityName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
