@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.JwtAuthenticationResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.JwtAuthenticationResponse.Companion.toKotlin as jwtAuthenticationResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AccessPolicy].
 */
@PulumiTagMarker
public class AccessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPolicyArgs = AccessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPolicyArgsBuilder.() -> Unit) {
        val builder = AccessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.videoanalyzer.AccessPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessPolicy(builtJavaResource)
    }
}

/**
 * Access policies help define the authentication rules, and control access to specific video resources.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * ## Example Usage
 * ### Register access policy entity.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessPolicy = new AzureNative.VideoAnalyzer.AccessPolicy("accessPolicy", new()
 *     {
 *         AccessPolicyName = "accessPolicyName1",
 *         AccountName = "testaccount2",
 *         Authentication = new AzureNative.VideoAnalyzer.Inputs.JwtAuthenticationArgs
 *         {
 *             Audiences = new[]
 *             {
 *                 "audience1",
 *             },
 *             Claims = new[]
 *             {
 *                 new AzureNative.VideoAnalyzer.Inputs.TokenClaimArgs
 *                 {
 *                     Name = "claimname1",
 *                     Value = "claimvalue1",
 *                 },
 *                 new AzureNative.VideoAnalyzer.Inputs.TokenClaimArgs
 *                 {
 *                     Name = "claimname2",
 *                     Value = "claimvalue2",
 *                 },
 *             },
 *             Issuers = new[]
 *             {
 *                 "issuer1",
 *                 "issuer2",
 *             },
 *             Keys =
 *             {
 *                 new AzureNative.VideoAnalyzer.Inputs.RsaTokenKeyArgs
 *                 {
 *                     Alg = AzureNative.VideoAnalyzer.AccessPolicyRsaAlgo.RS256,
 *                     E = "ZLFzZTY0IQ==",
 *                     Kid = "123",
 *                     N = "YmFzZTY0IQ==",
 *                     Type = "#Microsoft.VideoAnalyzer.RsaTokenKey",
 *                 },
 *                 new AzureNative.VideoAnalyzer.Inputs.EccTokenKeyArgs
 *                 {
 *                     Alg = AzureNative.VideoAnalyzer.AccessPolicyEccAlgo.ES256,
 *                     Kid = "124",
 *                     Type = "#Microsoft.VideoAnalyzer.EccTokenKey",
 *                     X = "XX==",
 *                     Y = "YY==",
 *                 },
 *             },
 *             Type = "#Microsoft.VideoAnalyzer.JwtAuthentication",
 *         },
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewAccessPolicy(ctx, "accessPolicy", &videoanalyzer.AccessPolicyArgs{
 * 			AccessPolicyName: pulumi.String("accessPolicyName1"),
 * 			AccountName:      pulumi.String("testaccount2"),
 * 			Authentication: &videoanalyzer.JwtAuthenticationArgs{
 * 				Audiences: pulumi.StringArray{
 * 					pulumi.String("audience1"),
 * 				},
 * 				Claims: videoanalyzer.TokenClaimArray{
 * 					&videoanalyzer.TokenClaimArgs{
 * 						Name:  pulumi.String("claimname1"),
 * 						Value: pulumi.String("claimvalue1"),
 * 					},
 * 					&videoanalyzer.TokenClaimArgs{
 * 						Name:  pulumi.String("claimname2"),
 * 						Value: pulumi.String("claimvalue2"),
 * 					},
 * 				},
 * 				Issuers: pulumi.StringArray{
 * 					pulumi.String("issuer1"),
 * 					pulumi.String("issuer2"),
 * 				},
 * 				Keys: pulumi.Array{
 * 					videoanalyzer.RsaTokenKey{
 * 						Alg:  videoanalyzer.AccessPolicyRsaAlgoRS256,
 * 						E:    "ZLFzZTY0IQ==",
 * 						Kid:  "123",
 * 						N:    "YmFzZTY0IQ==",
 * 						Type: "#Microsoft.VideoAnalyzer.RsaTokenKey",
 * 					},
 * 					videoanalyzer.EccTokenKey{
 * 						Alg:  videoanalyzer.AccessPolicyEccAlgoES256,
 * 						Kid:  "124",
 * 						Type: "#Microsoft.VideoAnalyzer.EccTokenKey",
 * 						X:    "XX==",
 * 						Y:    "YY==",
 * 					},
 * 				},
 * 				Type: pulumi.String("#Microsoft.VideoAnalyzer.JwtAuthentication"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.AccessPolicy;
 * import com.pulumi.azurenative.videoanalyzer.AccessPolicyArgs;
 * import com.pulumi.azurenative.videoanalyzer.inputs.JwtAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessPolicy = new AccessPolicy("accessPolicy", AccessPolicyArgs.builder()
 *             .accessPolicyName("accessPolicyName1")
 *             .accountName("testaccount2")
 *             .authentication(JwtAuthenticationArgs.builder()
 *                 .audiences("audience1")
 *                 .claims(
 *                     TokenClaimArgs.builder()
 *                         .name("claimname1")
 *                         .value("claimvalue1")
 *                         .build(),
 *                     TokenClaimArgs.builder()
 *                         .name("claimname2")
 *                         .value("claimvalue2")
 *                         .build())
 *                 .issuers(
 *                     "issuer1",
 *                     "issuer2")
 *                 .keys(
 *                     EccTokenKeyArgs.builder()
 *                         .alg("RS256")
 *                         .e("ZLFzZTY0IQ==")
 *                         .kid("123")
 *                         .n("YmFzZTY0IQ==")
 *                         .type("#Microsoft.VideoAnalyzer.RsaTokenKey")
 *                         .build(),
 *                     EccTokenKeyArgs.builder()
 *                         .alg("ES256")
 *                         .kid("124")
 *                         .type("#Microsoft.VideoAnalyzer.EccTokenKey")
 *                         .x("XX==")
 *                         .y("YY==")
 *                         .build())
 *                 .type("#Microsoft.VideoAnalyzer.JwtAuthentication")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:AccessPolicy accessPolicyName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/accessPolicies/{accessPolicyName}
 * ```
 */
public class AccessPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.videoanalyzer.AccessPolicy,
) : KotlinCustomResource(javaResource, AccessPolicyMapper) {
    /**
     * Authentication method to be used when validating client API access.
     */
    public val authentication: Output<JwtAuthenticationResponse>?
        get() = javaResource.authentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> jwtAuthenticationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the access level granted by this policy.
     */
    public val role: Output<String>?
        get() = javaResource.role().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccessPolicyMapper : ResourceMapper<AccessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.videoanalyzer.AccessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AccessPolicy = AccessPolicy(
        javaResource as
            com.pulumi.azurenative.videoanalyzer.AccessPolicy,
    )
}

/**
 * @see [AccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPolicy].
 */
public suspend fun accessPolicy(
    name: String,
    block: suspend AccessPolicyResourceBuilder.() -> Unit,
): AccessPolicy {
    val builder = AccessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPolicy(name: String): AccessPolicy {
    val builder = AccessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
