@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.AccountEncryptionResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.EndpointResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.IotHubResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.NetworkAccessControlResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.StorageAccountResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoAnalyzerIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.AccountEncryptionResponse.Companion.toKotlin as accountEncryptionResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.EndpointResponse.Companion.toKotlin as endpointResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.IotHubResponse.Companion.toKotlin as iotHubResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.NetworkAccessControlResponse.Companion.toKotlin as networkAccessControlResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.StorageAccountResponse.Companion.toKotlin as storageAccountResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoAnalyzerIdentityResponse.Companion.toKotlin as videoAnalyzerIdentityResponseToKotlin

/**
 * Builder for [VideoAnalyzer].
 */
@PulumiTagMarker
public class VideoAnalyzerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VideoAnalyzerArgs = VideoAnalyzerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VideoAnalyzerArgsBuilder.() -> Unit) {
        val builder = VideoAnalyzerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VideoAnalyzer {
        val builtJavaResource =
            com.pulumi.azurenative.videoanalyzer.VideoAnalyzer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VideoAnalyzer(builtJavaResource)
    }
}

/**
 * The Video Analyzer account.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2021-05-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:VideoAnalyzer contosomovies /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}
 * ```
 */
public class VideoAnalyzer internal constructor(
    override val javaResource: com.pulumi.azurenative.videoanalyzer.VideoAnalyzer,
) : KotlinCustomResource(javaResource, VideoAnalyzerMapper) {
    /**
     * The account encryption properties.
     */
    public val encryption: Output<AccountEncryptionResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    accountEncryptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The endpoints associated with this resource.
     */
    public val endpoints: Output<List<EndpointResponse>>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    endpointResponseToKotlin(args0)
                })
            })
        })

    /**
     * The identities associated to the Video Analyzer resource.
     */
    public val identity: Output<VideoAnalyzerIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    videoAnalyzerIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The IoT Hubs for this resource.
     */
    public val iotHubs: Output<List<IotHubResponse>>?
        get() = javaResource.iotHubs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> iotHubResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network access control for Video Analyzer.
     */
    public val networkAccessControl: Output<NetworkAccessControlResponse>?
        get() = javaResource.networkAccessControl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkAccessControlResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Private Endpoint Connections created under Video Analyzer account.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state of the Video Analyzer account.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Whether or not public network access is allowed for resources under the Video Analyzer account.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage accounts for this resource.
     */
    public val storageAccounts: Output<List<StorageAccountResponse>>
        get() = javaResource.storageAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageAccountResponseToKotlin(args0) })
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VideoAnalyzerMapper : ResourceMapper<VideoAnalyzer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.videoanalyzer.VideoAnalyzer::class == javaResource::class

    override fun map(javaResource: Resource): VideoAnalyzer = VideoAnalyzer(
        javaResource as
            com.pulumi.azurenative.videoanalyzer.VideoAnalyzer,
    )
}

/**
 * @see [VideoAnalyzer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VideoAnalyzer].
 */
public suspend fun videoAnalyzer(
    name: String,
    block: suspend VideoAnalyzerResourceBuilder.() -> Unit,
): VideoAnalyzer {
    val builder = VideoAnalyzerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VideoAnalyzer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun videoAnalyzer(name: String): VideoAnalyzer {
    val builder = VideoAnalyzerResourceBuilder()
    builder.name(name)
    return builder.build()
}
