@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.VideoArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.VideoArchivalArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.VideoArchivalArgsBuilder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.VideoMediaInfoArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.VideoMediaInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents a video resource within Azure Video Analyzer. Videos can be ingested from RTSP cameras through live pipelines or can be created by exporting sequences from existing captured video through a pipeline job. Videos ingested through live pipelines can be streamed through Azure Video Analyzer Player Widget or compatible players. Exported videos can be downloaded as MP4 files.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2021-05-01-preview.
 * ## Example Usage
 * ### Register video entity.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var video = new AzureNative.VideoAnalyzer.Video("video", new()
 *     {
 *         AccountName = "testaccount2",
 *         Description = "Sample Description 1",
 *         ResourceGroupName = "testrg",
 *         Title = "Sample Title 1",
 *         VideoName = "video1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewVideo(ctx, "video", &videoanalyzer.VideoArgs{
 * 			AccountName:       pulumi.String("testaccount2"),
 * 			Description:       pulumi.String("Sample Description 1"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Title:             pulumi.String("Sample Title 1"),
 * 			VideoName:         pulumi.String("video1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.Video;
 * import com.pulumi.azurenative.videoanalyzer.VideoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var video = new Video("video", VideoArgs.builder()
 *             .accountName("testaccount2")
 *             .description("Sample Description 1")
 *             .resourceGroupName("testrg")
 *             .title("Sample Title 1")
 *             .videoName("video1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:Video video1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/videos/{videoName}
 * ```
 * @property accountName The Azure Video Analyzer account name.
 * @property archival Video archival properties.
 * @property description Optional video description provided by the user. Value can be up to 2048 characters long.
 * @property mediaInfo Contains information about the video and audio content.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property title Optional video title provided by the user. Value can be up to 256 characters long.
 * @property videoName The Video name.
 */
public data class VideoArgs(
    public val accountName: Output<String>? = null,
    public val archival: Output<VideoArchivalArgs>? = null,
    public val description: Output<String>? = null,
    public val mediaInfo: Output<VideoMediaInfoArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val title: Output<String>? = null,
    public val videoName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.VideoArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.VideoArgs =
        com.pulumi.azurenative.videoanalyzer.VideoArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .archival(archival?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .mediaInfo(mediaInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .videoName(videoName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoArgs].
 */
@PulumiTagMarker
public class VideoArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var archival: Output<VideoArchivalArgs>? = null

    private var description: Output<String>? = null

    private var mediaInfo: Output<VideoMediaInfoArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var title: Output<String>? = null

    private var videoName: Output<String>? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("kroxshlnsjodqexy")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Video archival properties.
     */
    @JvmName("umofivtobfkjlybs")
    public suspend fun archival(`value`: Output<VideoArchivalArgs>) {
        this.archival = value
    }

    /**
     * @param value Optional video description provided by the user. Value can be up to 2048 characters long.
     */
    @JvmName("wptqkxkejvdvqelt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Contains information about the video and audio content.
     */
    @JvmName("kvrksbgvnrsgxdfk")
    public suspend fun mediaInfo(`value`: Output<VideoMediaInfoArgs>) {
        this.mediaInfo = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("reyisqwydgjvctvn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Optional video title provided by the user. Value can be up to 256 characters long.
     */
    @JvmName("ssojdirrecyppcpu")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The Video name.
     */
    @JvmName("fwmjabrowqtjyaip")
    public suspend fun videoName(`value`: Output<String>) {
        this.videoName = value
    }

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("roxjmvhcyotewpdb")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Video archival properties.
     */
    @JvmName("oubmaqabrkvupije")
    public suspend fun archival(`value`: VideoArchivalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archival = mapped
    }

    /**
     * @param argument Video archival properties.
     */
    @JvmName("sbhqtrrdftsxehcs")
    public suspend fun archival(argument: suspend VideoArchivalArgsBuilder.() -> Unit) {
        val toBeMapped = VideoArchivalArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.archival = mapped
    }

    /**
     * @param value Optional video description provided by the user. Value can be up to 2048 characters long.
     */
    @JvmName("cnvqlvkxwqprhwwq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Contains information about the video and audio content.
     */
    @JvmName("gkxpvdjdwsjoebgh")
    public suspend fun mediaInfo(`value`: VideoMediaInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaInfo = mapped
    }

    /**
     * @param argument Contains information about the video and audio content.
     */
    @JvmName("aaeaqwhllrtmaxwa")
    public suspend fun mediaInfo(argument: suspend VideoMediaInfoArgsBuilder.() -> Unit) {
        val toBeMapped = VideoMediaInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mediaInfo = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dydwedtdbniuqwsy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Optional video title provided by the user. Value can be up to 256 characters long.
     */
    @JvmName("mwjpapucpxofjggy")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The Video name.
     */
    @JvmName("jvgvitvqwfixahev")
    public suspend fun videoName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoName = mapped
    }

    internal fun build(): VideoArgs = VideoArgs(
        accountName = accountName,
        archival = archival,
        description = description,
        mediaInfo = mediaInfo,
        resourceGroupName = resourceGroupName,
        title = title,
        videoName = videoName,
    )
}
