@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Elliptical curve algorithm to be used: ES256, ES384 or ES512.
 */
public enum class AccessPolicyEccAlgo(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyEccAlgo,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyEccAlgo> {
    /**
     * ES265
     */
    ES256(com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyEccAlgo.ES256),

    /**
     * ES384
     */
    ES384(com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyEccAlgo.ES384),

    /**
     * ES512
     */
    ES512(com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyEccAlgo.ES512),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyEccAlgo = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyEccAlgo): AccessPolicyEccAlgo = AccessPolicyEccAlgo.values().first { it.javaValue == javaType }
    }
}
