@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of the built-in encoding preset.
 */
public enum class EncoderSystemPresetType(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.EncoderSystemPresetType,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.EncoderSystemPresetType> {
    /**
     * Produces an MP4 file where the video is encoded with H.264 codec at a picture height of 540 pixels, and at a maximum bitrate of 2000 Kbps. Encoded video has the same average frame rate as the input. The aspect ratio of the input is preserved. If the input content has audio, then it is encoded with AAC-LC codec at 96 Kbps
     */
    SingleLayer_540p_H264_AAC(com.pulumi.azurenative.videoanalyzer.enums.EncoderSystemPresetType.SingleLayer_540p_H264_AAC),

    /**
     * Produces an MP4 file where the video is encoded with H.264 codec at a picture height of 720 pixels, and at a maximum bitrate of 3500 Kbps. Encoded video has the same average frame rate as the input. The aspect ratio of the input is preserved. If the input content has audio, then it is encoded with AAC-LC codec at 96 Kbps
     */
    SingleLayer_720p_H264_AAC(com.pulumi.azurenative.videoanalyzer.enums.EncoderSystemPresetType.SingleLayer_720p_H264_AAC),

    /**
     * Produces an MP4 file where the video is encoded with H.264 codec at a picture height of 1080 pixels, and at a maximum bitrate of 6000 Kbps. Encoded video has the same average frame rate as the input. The aspect ratio of the input is preserved. If the input content has audio, then it is encoded with AAC-LC codec at 128 Kbps
     */
    SingleLayer_1080p_H264_AAC(com.pulumi.azurenative.videoanalyzer.enums.EncoderSystemPresetType.SingleLayer_1080p_H264_AAC),

    /**
     * Produces an MP4 file where the video is encoded with H.264 codec at a picture height of 2160 pixels, and at a maximum bitrate of 16000 Kbps. Encoded video has the same average frame rate as the input. The aspect ratio of the input is preserved. If the input content has audio, then it is encoded with AAC-LC codec at 128 Kbps
     */
    SingleLayer_2160p_H264_AAC(com.pulumi.azurenative.videoanalyzer.enums.EncoderSystemPresetType.SingleLayer_2160p_H264_AAC),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.EncoderSystemPresetType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.EncoderSystemPresetType): EncoderSystemPresetType =
            EncoderSystemPresetType.values().first { it.javaValue == javaType }
    }
}
