@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the parameter.
 */
public enum class ParameterType(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.ParameterType,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.ParameterType> {
    /**
     * The parameter's value is a string.
     */
    String(com.pulumi.azurenative.videoanalyzer.enums.ParameterType.String),

    /**
     * The parameter's value is a string that holds sensitive information.
     */
    SecretString(com.pulumi.azurenative.videoanalyzer.enums.ParameterType.SecretString),

    /**
     * The parameter's value is a 32-bit signed integer.
     */
    Int(com.pulumi.azurenative.videoanalyzer.enums.ParameterType.Int),

    /**
     * The parameter's value is a 64-bit double-precision floating point.
     */
    Double(com.pulumi.azurenative.videoanalyzer.enums.ParameterType.Double),

    /**
     * The parameter's value is a boolean value that is either true or false.
     */
    Bool(com.pulumi.azurenative.videoanalyzer.enums.ParameterType.Bool),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.ParameterType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.ParameterType): ParameterType = ParameterType.values().first { it.javaValue == javaType }
    }
}
