@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether or not public network access is allowed for resources under the Video Analyzer account.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.PublicNetworkAccess> {
    /**
     * Public network access is enabled.
     */
    Enabled(com.pulumi.azurenative.videoanalyzer.enums.PublicNetworkAccess.Enabled),

    /**
     * Public network access is disabled.
     */
    Disabled(com.pulumi.azurenative.videoanalyzer.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.PublicNetworkAccess): PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
