@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Network transport utilized by the RTSP and RTP exchange: TCP or HTTP. When using TCP, the RTP packets are interleaved on the TCP RTSP connection. When using HTTP, the RTSP messages are exchanged through long lived HTTP connections, and the RTP packages are interleaved in the HTTP connections alongside the RTSP messages.
 */
public enum class RtspTransport(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.RtspTransport,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.RtspTransport> {
    /**
     * HTTP transport. RTSP messages are exchanged over long running HTTP requests and RTP packets are interleaved within the HTTP channel.
     */
    Http(com.pulumi.azurenative.videoanalyzer.enums.RtspTransport.Http),

    /**
     * TCP transport. RTSP is used directly over TCP and RTP packets are interleaved within the TCP channel.
     */
    Tcp(com.pulumi.azurenative.videoanalyzer.enums.RtspTransport.Tcp),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.RtspTransport = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.RtspTransport): RtspTransport = RtspTransport.values().first { it.javaValue == javaType }
    }
}
