@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.EccTokenKeyArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.enums.AccessPolicyEccAlgo
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Required validation properties for tokens generated with Elliptical Curve algorithm.
 * @property alg Elliptical curve algorithm to be used: ES256, ES384 or ES512.
 * @property kid JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
 * @property x X coordinate.
 * @property y Y coordinate.
 */
public data class EccTokenKeyArgs(
    public val alg: Output<Either<String, AccessPolicyEccAlgo>>,
    public val kid: Output<String>,
    public val type: Output<String>,
    public val x: Output<String>,
    public val y: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.EccTokenKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.EccTokenKeyArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.EccTokenKeyArgs.builder()
            .alg(
                alg.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .kid(kid.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .x(x.applyValue({ args0 -> args0 }))
            .y(y.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EccTokenKeyArgs].
 */
@PulumiTagMarker
public class EccTokenKeyArgsBuilder internal constructor() {
    private var alg: Output<Either<String, AccessPolicyEccAlgo>>? = null

    private var kid: Output<String>? = null

    private var type: Output<String>? = null

    private var x: Output<String>? = null

    private var y: Output<String>? = null

    /**
     * @param value Elliptical curve algorithm to be used: ES256, ES384 or ES512.
     */
    @JvmName("oubuscthbelsyhhu")
    public suspend fun alg(`value`: Output<Either<String, AccessPolicyEccAlgo>>) {
        this.alg = value
    }

    /**
     * @param value JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
     */
    @JvmName("luekyegealhtppmg")
    public suspend fun kid(`value`: Output<String>) {
        this.kid = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
     */
    @JvmName("ddyacuoegopcjnpr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value X coordinate.
     */
    @JvmName("mudyuldixivlqybq")
    public suspend fun x(`value`: Output<String>) {
        this.x = value
    }

    /**
     * @param value Y coordinate.
     */
    @JvmName("ixtjinbxhqhojruk")
    public suspend fun y(`value`: Output<String>) {
        this.y = value
    }

    /**
     * @param value Elliptical curve algorithm to be used: ES256, ES384 or ES512.
     */
    @JvmName("jkgihujxjlkyhvgq")
    public suspend fun alg(`value`: Either<String, AccessPolicyEccAlgo>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alg = mapped
    }

    /**
     * @param value Elliptical curve algorithm to be used: ES256, ES384 or ES512.
     */
    @JvmName("estsykspopkistll")
    public fun alg(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessPolicyEccAlgo>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alg = mapped
    }

    /**
     * @param value Elliptical curve algorithm to be used: ES256, ES384 or ES512.
     */
    @JvmName("mdtqygrbnbkkobqp")
    public fun alg(`value`: AccessPolicyEccAlgo) {
        val toBeMapped = Either.ofRight<String, AccessPolicyEccAlgo>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alg = mapped
    }

    /**
     * @param value JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
     */
    @JvmName("fxebbotfmowjuppc")
    public suspend fun kid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kid = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
     */
    @JvmName("hvoonvcesokmkegn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value X coordinate.
     */
    @JvmName("jrvwkaokeufuxeiu")
    public suspend fun x(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.x = mapped
    }

    /**
     * @param value Y coordinate.
     */
    @JvmName("bjqixbehvdbjsvre")
    public suspend fun y(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.y = mapped
    }

    internal fun build(): EccTokenKeyArgs = EccTokenKeyArgs(
        alg = alg ?: throw PulumiNullFieldException("alg"),
        kid = kid ?: throw PulumiNullFieldException("kid"),
        type = type ?: throw PulumiNullFieldException("type"),
        x = x ?: throw PulumiNullFieldException("x"),
        y = y ?: throw PulumiNullFieldException("y"),
    )
}
