@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.EncoderCustomPresetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a custom preset for encoding the input content using the encoder processor.
 * @property audioEncoder Describes a custom preset for encoding audio.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.EncoderCustomPreset'.
 * @property videoEncoder Describes a custom preset for encoding video.
 */
public data class EncoderCustomPresetArgs(
    public val audioEncoder: Output<AudioEncoderAacArgs>? = null,
    public val type: Output<String>,
    public val videoEncoder: Output<VideoEncoderH264Args>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.EncoderCustomPresetArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.EncoderCustomPresetArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.EncoderCustomPresetArgs.builder()
            .audioEncoder(audioEncoder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 }))
            .videoEncoder(videoEncoder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EncoderCustomPresetArgs].
 */
@PulumiTagMarker
public class EncoderCustomPresetArgsBuilder internal constructor() {
    private var audioEncoder: Output<AudioEncoderAacArgs>? = null

    private var type: Output<String>? = null

    private var videoEncoder: Output<VideoEncoderH264Args>? = null

    /**
     * @param value Describes a custom preset for encoding audio.
     */
    @JvmName("hostcnrvdglmwkud")
    public suspend fun audioEncoder(`value`: Output<AudioEncoderAacArgs>) {
        this.audioEncoder = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.EncoderCustomPreset'.
     */
    @JvmName("pygnngkhtmxfvkkk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Describes a custom preset for encoding video.
     */
    @JvmName("gpbokrfvpdysbtln")
    public suspend fun videoEncoder(`value`: Output<VideoEncoderH264Args>) {
        this.videoEncoder = value
    }

    /**
     * @param value Describes a custom preset for encoding audio.
     */
    @JvmName("xcjlkcnvophjmtvg")
    public suspend fun audioEncoder(`value`: AudioEncoderAacArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioEncoder = mapped
    }

    /**
     * @param argument Describes a custom preset for encoding audio.
     */
    @JvmName("gqfatrlkqcukrbak")
    public suspend fun audioEncoder(argument: suspend AudioEncoderAacArgsBuilder.() -> Unit) {
        val toBeMapped = AudioEncoderAacArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.audioEncoder = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.EncoderCustomPreset'.
     */
    @JvmName("mgiybeyxisjfkyid")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Describes a custom preset for encoding video.
     */
    @JvmName("juondohlikulhabj")
    public suspend fun videoEncoder(`value`: VideoEncoderH264Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoEncoder = mapped
    }

    /**
     * @param argument Describes a custom preset for encoding video.
     */
    @JvmName("wbgsgdhsfdmjioke")
    public suspend fun videoEncoder(argument: suspend VideoEncoderH264ArgsBuilder.() -> Unit) {
        val toBeMapped = VideoEncoderH264ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.videoEncoder = mapped
    }

    internal fun build(): EncoderCustomPresetArgs = EncoderCustomPresetArgs(
        audioEncoder = audioEncoder,
        type = type ?: throw PulumiNullFieldException("type"),
        videoEncoder = videoEncoder,
    )
}
