@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.GetAccessPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessPolicyName The Access Policy name.
 * @property accountName The Azure Video Analyzer account name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAccessPolicyPlainArgs(
    public val accessPolicyName: String,
    public val accountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.GetAccessPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.GetAccessPolicyPlainArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.GetAccessPolicyPlainArgs.builder()
            .accessPolicyName(accessPolicyName.let({ args0 -> args0 }))
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetAccessPolicyPlainArgsBuilder internal constructor() {
    private var accessPolicyName: String? = null

    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Access Policy name.
     */
    @JvmName("lkhyumcreytjfcqe")
    public suspend fun accessPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessPolicyName = mapped
    }

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("wkkxwisoyeapmjod")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bmdwkalrchlrtuot")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccessPolicyPlainArgs = GetAccessPolicyPlainArgs(
        accessPolicyName = accessPolicyName ?: throw PulumiNullFieldException("accessPolicyName"),
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
