@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.TlsEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * TLS endpoint describes an endpoint that the pipeline can connect to over TLS transport (data is encrypted in transit).
 * @property credentials Credentials to be presented to the endpoint.
 * @property trustedCertificates List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
 * @property tunnel Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.TlsEndpoint'.
 * @property url The endpoint URL for Video Analyzer to connect to.
 * @property validationOptions Validation options to use when authenticating a TLS connection. By default, strict validation is used.
 */
public data class TlsEndpointArgs(
    public val credentials: Output<UsernamePasswordCredentialsArgs>,
    public val trustedCertificates: Output<PemCertificateListArgs>? = null,
    public val tunnel: Output<SecureIotDeviceRemoteTunnelArgs>? = null,
    public val type: Output<String>,
    public val url: Output<String>,
    public val validationOptions: Output<TlsValidationOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.TlsEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.TlsEndpointArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.TlsEndpointArgs.builder()
            .credentials(credentials.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trustedCertificates(
                trustedCertificates?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tunnel(tunnel?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 }))
            .validationOptions(
                validationOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TlsEndpointArgs].
 */
@PulumiTagMarker
public class TlsEndpointArgsBuilder internal constructor() {
    private var credentials: Output<UsernamePasswordCredentialsArgs>? = null

    private var trustedCertificates: Output<PemCertificateListArgs>? = null

    private var tunnel: Output<SecureIotDeviceRemoteTunnelArgs>? = null

    private var type: Output<String>? = null

    private var url: Output<String>? = null

    private var validationOptions: Output<TlsValidationOptionsArgs>? = null

    /**
     * @param value Credentials to be presented to the endpoint.
     */
    @JvmName("fktpuhayjiulhtfv")
    public suspend fun credentials(`value`: Output<UsernamePasswordCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
     */
    @JvmName("epaqtqdllkhpuagh")
    public suspend fun trustedCertificates(`value`: Output<PemCertificateListArgs>) {
        this.trustedCertificates = value
    }

    /**
     * @param value Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
     */
    @JvmName("ykciupexjhglkmyc")
    public suspend fun tunnel(`value`: Output<SecureIotDeviceRemoteTunnelArgs>) {
        this.tunnel = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.TlsEndpoint'.
     */
    @JvmName("vudgxqcrrirfpqbx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The endpoint URL for Video Analyzer to connect to.
     */
    @JvmName("bixtkqwdjsgglsob")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Validation options to use when authenticating a TLS connection. By default, strict validation is used.
     */
    @JvmName("qmkwclvrxpfvojra")
    public suspend fun validationOptions(`value`: Output<TlsValidationOptionsArgs>) {
        this.validationOptions = value
    }

    /**
     * @param value Credentials to be presented to the endpoint.
     */
    @JvmName("iyjtkidwdihhbmir")
    public suspend fun credentials(`value`: UsernamePasswordCredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Credentials to be presented to the endpoint.
     */
    @JvmName("atheesoapkopcvly")
    public suspend fun credentials(argument: suspend UsernamePasswordCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = UsernamePasswordCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
     */
    @JvmName("surcargpkplmrovu")
    public suspend fun trustedCertificates(`value`: PemCertificateListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCertificates = mapped
    }

    /**
     * @param argument List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
     */
    @JvmName("tqlakqvrsoxsmjtx")
    public suspend fun trustedCertificates(argument: suspend PemCertificateListArgsBuilder.() -> Unit) {
        val toBeMapped = PemCertificateListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trustedCertificates = mapped
    }

    /**
     * @param value Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
     */
    @JvmName("isuemypwqewmsyjq")
    public suspend fun tunnel(`value`: SecureIotDeviceRemoteTunnelArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnel = mapped
    }

    /**
     * @param argument Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
     */
    @JvmName("amabsknkwqdvlmxt")
    public suspend fun tunnel(argument: suspend SecureIotDeviceRemoteTunnelArgsBuilder.() -> Unit) {
        val toBeMapped = SecureIotDeviceRemoteTunnelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tunnel = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.TlsEndpoint'.
     */
    @JvmName("umtvrmfohhrjkjen")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The endpoint URL for Video Analyzer to connect to.
     */
    @JvmName("ewuniwpmqtehuvrp")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Validation options to use when authenticating a TLS connection. By default, strict validation is used.
     */
    @JvmName("ldjjwbchweubdvmf")
    public suspend fun validationOptions(`value`: TlsValidationOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationOptions = mapped
    }

    /**
     * @param argument Validation options to use when authenticating a TLS connection. By default, strict validation is used.
     */
    @JvmName("ihlhienajvkmvrsh")
    public suspend fun validationOptions(argument: suspend TlsValidationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = TlsValidationOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationOptions = mapped
    }

    internal fun build(): TlsEndpointArgs = TlsEndpointArgs(
        credentials = credentials ?: throw PulumiNullFieldException("credentials"),
        trustedCertificates = trustedCertificates,
        tunnel = tunnel,
        type = type ?: throw PulumiNullFieldException("type"),
        url = url ?: throw PulumiNullFieldException("url"),
        validationOptions = validationOptions,
    )
}
