@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.TlsValidationOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Options for controlling the validation of TLS endpoints.
 * @property ignoreHostname When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
 * @property ignoreSignature When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
 */
public data class TlsValidationOptionsArgs(
    public val ignoreHostname: Output<String>? = null,
    public val ignoreSignature: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.TlsValidationOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.TlsValidationOptionsArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.TlsValidationOptionsArgs.builder()
            .ignoreHostname(ignoreHostname?.applyValue({ args0 -> args0 }))
            .ignoreSignature(ignoreSignature?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TlsValidationOptionsArgs].
 */
@PulumiTagMarker
public class TlsValidationOptionsArgsBuilder internal constructor() {
    private var ignoreHostname: Output<String>? = null

    private var ignoreSignature: Output<String>? = null

    /**
     * @param value When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
     */
    @JvmName("kioiqjajduawplyr")
    public suspend fun ignoreHostname(`value`: Output<String>) {
        this.ignoreHostname = value
    }

    /**
     * @param value When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
     */
    @JvmName("lqewyxgglaatqkaq")
    public suspend fun ignoreSignature(`value`: Output<String>) {
        this.ignoreSignature = value
    }

    /**
     * @param value When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
     */
    @JvmName("jgksohpemcmncxhv")
    public suspend fun ignoreHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreHostname = mapped
    }

    /**
     * @param value When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
     */
    @JvmName("daqbefybnlarobjl")
    public suspend fun ignoreSignature(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreSignature = mapped
    }

    internal fun build(): TlsValidationOptionsArgs = TlsValidationOptionsArgs(
        ignoreHostname = ignoreHostname,
        ignoreSignature = ignoreSignature,
    )
}
