@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.TokenClaimArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties for expected token claims.
 * @property name Name of the claim which must be present on the token.
 * @property value Expected value of the claim to be present on the token.
 */
public data class TokenClaimArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.TokenClaimArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.TokenClaimArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.TokenClaimArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TokenClaimArgs].
 */
@PulumiTagMarker
public class TokenClaimArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the claim which must be present on the token.
     */
    @JvmName("apnuxqawpuopmpac")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Expected value of the claim to be present on the token.
     */
    @JvmName("kwnmhvjvdeslmexq")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the claim which must be present on the token.
     */
    @JvmName("xhqfsmgonbicjddg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Expected value of the claim to be present on the token.
     */
    @JvmName("eahnwhrctgkuvars")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TokenClaimArgs = TokenClaimArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
